#version 130
#extension GL_EXT_gpu_shader4 : enable
// 2d flicker animationMod01.fsh  by   cxm
 
//https://www.shadertoy.com/view/sltSRB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 _rot1(float a) {
  float s = sin(a), c = cos(a);
  return mat2(c,s,-s,c);
}

float getCircle( float r, in vec2 uv, in vec2 bUv, float rot ){
    
    vec2 u = _rot1( rot ) * uv;
    
    float f = ( ( ( u.x / 3. ) / (  ( u.y ) ) ) );
    
    float p = mod( smoothstep( .3, 6., f * 10. ) * 5., .5 );

    p = 1. - mix(
        smoothstep(
            distance( bUv, vec2( .5 * iResolution.x / iResolution.y, .5 ) ),
            .25 * r,
            .24 * r
        ),
        1.,
        1. - p
    );
    
    return p;

}

vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    vec2 bUv = fragCoord/iResolution.yy;
    
    uv = abs( uv - .5 ) * 2.;

    // Time varying pixel color
    vec3 col;
    
    float p;
    
    for( float i = 1.; i < 8.; i++ ){
        p += mix(
            p,
            1.,
            getCircle( 1. + .1 * i, uv, bUv, iTime * i )
        );
        
    }
    
    col += p;

    // Output to screen
    fragColor = vec4(col,1.0);
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.